/**
 * plugin.js
 *
 * Copyright, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/*global tinymce:true */

tinymce.ScriptLoader.load(tinyMCE.baseURL + '/plugins/pagelink/pagelink.php');

tinymce.PluginManager.add('pagelink', function(editor) {
	function showDialog() {
		var data = {}, selection = editor.selection, dom = editor.dom, selectedElm, anchorElm, initialText;
		var win, linkListCtrl, relListCtrl, targetListCtrl;

		function buildLinkList() {
			var linkListItems = [{text: 'None', value: ''}];

			tinymce.each(editor.settings.link_list, function(link) {
				linkListItems.push({
					text: link.text || link.title,
					value: link.value || link.url,
					menu: link.menu
				});
			});

			return linkListItems;
		}

		function buildRelList(relValue) {
			var relListItems = [{text: 'None', value: ''}];

			tinymce.each(editor.settings.rel_list, function(rel) {
				relListItems.push({
					text: rel.text || rel.title,
					value: rel.value,
					selected: relValue === rel.value
				});
			});

			return relListItems;
		}

		function buildLinkClassList(relValue) {
			var linkClassListItems = [{text: 'None', value: ''}];

			tinymce.each(editor.settings.link_class_list, function(rel) {
				linkClassListItems.push({
					text: rel.text || rel.title,
					value: rel.value,
					selected: relValue === rel.value
				});
			});

			return linkClassListItems;
		}
		
		function buildTargetList(targetValue) {
			var targetListItems = [{text: 'None', value: ''}];

			if (!editor.settings.target_list) {
				targetListItems.push({text: 'New window', value: '_blank'});
			}

			tinymce.each(editor.settings.target_list, function(target) {
				targetListItems.push({
					text: target.text || target.title,
					value: target.value,
					selected: targetValue === target.value
				});
			});

			return targetListItems;
		}

		function updateText() {
			if (!initialText && data.text.length === 0) {
				this.parent().parent().find('#text')[0].value(this.value());
			}
		}

		selectedElm = selection.getNode();
		anchorElm = dom.getParent(selectedElm, 'a[href]');
		if (anchorElm) {
			selection.select(anchorElm);
		}

		data.text = initialText = selection.getContent({format: 'text'});
		data.href = anchorElm ? dom.getAttrib(anchorElm, 'href') : '';
		data.target = anchorElm ? dom.getAttrib(anchorElm, 'target') : '';
		data.rel = anchorElm ? dom.getAttrib(anchorElm, 'rel') : '';
		data.linkclass = anchorElm ? dom.getAttrib(anchorElm, 'class') : '';

		if (selectedElm.nodeName == "IMG") {
			data.text = initialText = " ";
		}
		
		/**
		 *	Aldus: patch
		 */
		// if(data.href === "") data.href = pagelist[0].value;
		data.text = true;

		if (editor.settings.target_list !== false) {
			targetListCtrl = {
				name: 'target',
				type: 'listbox',
				label: 'Target',
				values: buildTargetList(data.target)
			};
		}

		if (editor.settings.rel_list) {
			relListCtrl = {
				name: 'rel',
				type: 'listbox',
				label: 'Rel',
				values: buildRelList(data.rel)
			};
		}

		if (editor.settings.link_class_list) {
			linkClassListCtrl = {
				name: 'linkclass',
				type: 'listbox',
				label: 'Class',
				values: buildLinkClassList(data.linkclass)
			};
		} else {
			linkClassListCtrl = 0;
		}
		
		function set_selected_in_pagelist( aLookUpValue ){
			var temp_selected = aLookUpValue.replace("[wblink", "");
			temp_selected = temp_selected.replace("]", "");
			for(var i=0; i < pagelist.length; i++){
				if( temp_selected == pagelist[i].value ) {
					pagelist[i].selected = true;
					// console.log("found: "+temp_selected+" from: "+aLookUpValue);
				}
			}
			return pagelist;
		}
		
		win = editor.windowManager.open({
			title: 'Insert link',
			data: data,
			body: [
				{
					name: 'href',
					type: 'listbox',
					size: 40,
					autofocus: false,
					label: 'Internal page',
					values: set_selected_in_pagelist( data.href ), // #1
					value: data.href,
					onselect: function(e) {
						var textCtrl = win.find('#text');
						// console.log( "call x: "+e.control.value() );
						if (!textCtrl.value() || (e.lastControl && textCtrl.value() == e.lastControl.text())) {
							textCtrl.value(e.control.text());
						}

						win.find('#href').value(e.control.value());
					}
				},
				{	name: 'text',
					type: 'checkbox',
					size: 40,
					label: 'Use PageTitle',
					checked: true,
					onclick: function() {
						data.text = this.value();
						// alert(data.text);
					}
				},
				relListCtrl,
				targetListCtrl,
				linkClassListCtrl
			],
			onSubmit: function(e) {
				var data = e.data;

				if (!data.href) {
					editor.execCommand('unlink');
					return;
				}
				
				if (data.text === true) {
					for(var i = 0; i < pagelist.length; i++) {
						if (pagelist[i].value == data.href) {
							data.text = pagelist[i].text; // #2
						}
					}
				} else {
					data.text = initialText;
				}
				
				data.href = "[wblink" + data.href + "]";
				
				if (data.text != initialText) {
					if (anchorElm) {
						editor.focus();
						anchorElm.innerHTML = data.text;

						dom.setAttribs(anchorElm, {
							href: data.href,
							target: data.target ? data.target : null,
							rel: data.rel ? data.rel : null,
							class: data.linkclass ? data.linkclass : null
						});

						selection.select(anchorElm);
					} else {
						editor.insertContent(dom.createHTML('a', {
							href: data.href,
							target: data.target ? data.target : null,
							rel: data.rel ? data.rel : null,
							class: data.linkclass ? data.linkclass : null
						}, data.text));
					}
				} else {
					editor.execCommand('mceInsertLink', false, {
						href: data.href,
						target: data.target,
						rel: data.rel ? data.rel : null,
						class: data.linkclass ? data.linkclass : null
					});
				}
			}
		});
	}

	editor.addButton('pagelink', {
		icon: 'pagelink',
		image: tinyMCE.baseURL + "/plugins/pagelink/img/pagelink.png",
		tooltip: 'Insert/edit a lepton-pagelink',
		shortcut: 'Ctrl+K',
		onclick: showDialog,
		stateSelector: 'a[href]'
	});

	editor.addShortcut('Ctrl+K', '', showDialog);

	this.showDialog = showDialog;

	editor.addMenuItem('pagelink', {
		icon: 'pagelink',
		text: 'Insert a lepton-pagelink',
		shortcut: 'Ctrl+K',
		onclick: showDialog,
		stateSelector: 'a[href]',
		context: 'insert',
		prependToContext: true
	});
});