<?php

/**
 *  @module         news
 *  @version        see info.php of this module
 *  @author         Ryan Djurovich, Rob Smith, Dietrich Roland Pehlke, Christian M. Stefan (Stefek), Jurgen Nijhuis (Argos), LEPTON Project
 *  @copyright      2004-2010 Ryan Djurovich, Rob Smith, Dietrich Roland Pehlke, Christian M. Stefan (Stefek), Jurgen Nijhuis (Argos) 
 * 	@copyright      2010-2020 LEPTON Project 
 *  @license        GNU General Public License
 *  @license terms  see info.php of this module
 *  @platform       see info.php of this module
 * 
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

$sLookForFolder = LEPTON_PATH.MEDIA_DIRECTORY."/.news";
if(file_exists($sLookForFolder))
{
    LEPTON_handle::register( "make_dir", "rename_recursive_dirs" );
    
    make_dir(LEPTON_PATH.MEDIA_DIRECTORY.'/newspics');
	make_dir(LEPTON_PATH.MEDIA_DIRECTORY.'/newspics/groups');
	
    rename_recursive_dirs( $sLookForFolder, LEPTON_PATH.MEDIA_DIRECTORY."/newspics/groups/" );
}
// delete obsolete file
LEPTON_handle::delete_obsolete_files('/modules/news/register_language.php', '/modules/news/register_parser.php');
LEPTON_handle::delete_obsolete_files( MEDIA_DIRECTORY."/.news" );
