<?php

/**
 *
 *	@module			quickform
 *	@version		see info.php of this module
 *	@authors		Ruud Eisinga, LEPTON project
 *	@copyright		2012-2020 Ruud Eisinga, LEPTON project
 *  @license        GNU General Public License
 *  @license terms  see info.php of this module
 *  @platform       see info.php of this module
 *
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {
	include(LEPTON_PATH.'/framework/class.secure.php');
} else {
	$root = "../";
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= "../";
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) {
		include($root.'/framework/class.secure.php');
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php 

class quickform extends LEPTON_abstract {
	
	public $templates = array();
	public $attachements = array();
	public $isArray = false;
	public $fieldGetSeen = false;

	public $error;
	public $current = '';
	public $next = '';

	/**
	 *	The reference to *Singleton* instance of this class
	 *
	 *	@var	object
	 *	@access	private
	 *
	 */
	public static $instance;
	
	public function initialize () {
		
	}

	public function __construct($section_id = 0) {

	}
	

	//	Get a catcha
	public function captcha($section_id = 0) {
		
		if(file_exists( LEPTON_PATH."/modules/quickform/recaptcha.php" ))
		{
			require_once LEPTON_PATH."/modules/quickform/recaptcha.php";
			return quickform_recaptcha::build_captcha();
		}
		
		require_once(LEPTON_PATH.'/modules/captcha_control/captcha/captcha.php');
		ob_start();
			call_captcha("all","",$section_id);
			$captcha = ob_get_clean();
		return $captcha;
	}
	

	public function delete_record( $id) {
		global $database;
		$result = array();
		$res = $database->simple_query("DELETE FROM ".TABLE_PREFIX."mod_quickform_data WHERE message_id = ".$id );
		return;
	}

    /**
     *
     * Get the submissions of this section
     *
     * @param   int     A valid section id
     * @param   int     Optional numger of max rows
     * @return  array   A linear array within assoc. subarray
     *
     */
	public function get_history ( $id, $max = 20 ) {
		
		$database = LEPTON_database::getInstance();
		$result = array();
		$database->execute_query(
			"SELECT * FROM `".TABLE_PREFIX."mod_quickform_data` WHERE `section_id` = '".$id."' order by `message_id` desc limit 0,".$max,
			true,
			$result,
			true
		);
		return $result;
	}

    /**
     *
     * Build page list
     *
     * @param   int     A valid parent page id
     * @param   int     Current page_id
     * @return  array   A assoc. array
     *
     */	
	public function build_pagelist($parent, $this_page) {
		global $database, $links;
		$iterated_parents = array(); // keep count of already iterated parents to prevent duplicates

		$infos = array();
		$database->execute_query(
			"SELECT link, menu_title, page_title, page_id, level FROM ".TABLE_PREFIX."pages WHERE parent = ".$parent." ORDER BY level, position ASC",
			true,
			$infos,
			true
		);			
	
		if (count($infos) > 0) 
		{
			foreach($infos as $res) 
			{
				$links[$res['page_id']] = $res['page_id'].'|'.str_repeat("  -  ",$res['level']).$res['menu_title'].' ('.$res['page_title'].')';
				if (!in_array($res['page_id'], $iterated_parents)) 
				{
					$this->build_pagelist($res['page_id'], $this_page);
					$iterated_parents[] = $res['page_id'];
				}
			}
		}
	}
	
	/**
	 *	@param	string	To_address
	 *	@param	string	Subject
	 *	@param	string	Message
	 *	@param	string	From name
	 *	@param	string	Reply to
	 *	@param	array	Attachments
	 */	
	public function mail($toaddress, $subject, $message, $fromname='', $replyto = '', $attachments=array() ) {

		$toArray = explode(',',$toaddress);
		$fromaddress = $toArray[0];
		$myMail = LEPTON_mailer::getInstance();
		
		// // set user defined from address
		// if ($fromaddress!='') {
		// 	if($fromname!='') $myMail->FromName = $fromname;  	// FROM-NAME
		// 	$myMail->From = $fromaddress;                     	// FROM:
		// }
		
//		if ($replyto!='') {
//			$myMail->AddReplyTo($replyto);              	  	// REPLY TO:
//		}
		
		foreach ($toArray as $toAddr) {							// TO:
			$myMail->AddAddress($toAddr);
		}
		$myMail->Subject = $subject;                          	// SUBJECT
		$myMail->Body = $message; 		                     	// CONTENT (HTML)
		$textbody = strip_tags($message);  
		$textbody = str_replace("\t","",$textbody);  
		while (strpos($textbody,"\n\n\n") !== false) 
			$textbody = str_replace("\n\n\n","\n\n",$textbody);  
		while (strpos($textbody,"\r\n\r\n\r\n") !== false) 
			$textbody = str_replace("\r\n\r\n\r\n","\r\n\r\n",$textbody);  
		$myMail->AltBody = $textbody;			              	// CONTENT (TEXT)
		
		$myMail->CharSet="UTF-8";	
		
		foreach($this->attachements as $filename => $file) {
			$myMail->AddAttachment($file, $filename);
		}
		
		foreach( $attachments as &$ref ) {
			$myMail->addAttachment($ref['path'], $ref['name']);
		}
		
		// check if there are any send mail errors, otherwise say successful
		if (!$myMail->Send()) {
			die( "Error Quickform:" .$myMail->ErrorInfo );
			return false;
		} else {
			return true;
		}
	}
} //end class