<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          wysiwyg
 * @author          Ryan Djurovich
 * @author          LEPTON Project
 * @copyright       2004-2010 WebsiteBaker Project
 * @copyright       2010-2020 LEPTON Project 
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

// Include admin wrapper script
$update_when_modified = true; // Tells script to update when this page was last updated
require(LEPTON_PATH.'/modules/admin.php');

/**
 *	Update the mod_wysiwygs table with the contents
 *
 */
if(isset($_POST['content'.$section_id]))
{
	$_POST['content'] = str_replace("\\\$", "\$", $_POST['content'.$section_id]);

	// Searching in $text will be much easier this way
	$_POST['text'] = strip_tags($_POST['content']);

	$oREQUEST = LEPTON_request::getInstance();	

	$all_names = array (
		'content'	=> array ('type' => 'string_chars', 'default' => ""),
		'text'		=> array ('type' => 'string_clean', 'default' => "")
	);		

	$all_values = $oREQUEST->testPostValues($all_names);	

	$table = TABLE_PREFIX."mod_wysiwyg";
	$database->build_and_execute(
		'UPDATE', 
		$table, 
		$all_values,
		"section_id = ".$section_id
	);	
}

//  Keep in mind that the "print_success" (class-)method also echos the footer!
$redirect = ADMIN_URL.'/pages/modify.php?page_id='.$page_id.'#'.SEC_ANCHOR.$section_id;
$admin->print_success($MESSAGE['PAGES_SAVED'], $redirect );

