<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2019 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);

echo ('<h3>Current process : updating to LEPTON 4.2.0</h3>');

// delete obsolete directories
echo ('<h5>Current process : delete obsolete directories</h5>');	

$directory_names = array(
	'/templates/algos/backend/code2',
	'/templates/algos/backend/form',
	'/templates/algos/backend/news',
	'/templates/algos/backend/wrapper',
	'/templates/algos/backend/wysiwyg',
	'/templates/algos/backend/wysiwyg_admin'
);
LEPTON_handle::delete_obsolete_directories($directory_names);

echo ('<h5>Delete obsolete directories: successful</h5>');	



 
echo '<h5>Current process : run modules upgrade.php</h5>';  
		 
$module_names = array(
	"lib_phpmailer",
	'lib_r_filemanager',
	"lib_search",
	"lib_twig",
	"news",
	"show_menu2",
	"tinymce",
	"wrapper"
);
LEPTON_handle::upgrade_modules($module_names);

echo "<h5>run upgrade.php of modified modules: successfull</h5>";

		
echo '<h5>reload all addons</h5>';
		
if (file_exists (LEPTON_PATH.'/install/update/reload.php')) {
		require_once(LEPTON_PATH . '/install/update/reload.php');
}	
		
echo "<h5>reload all addons: successfull</h5>";

// update release and success message
echo ('<h5>Current process : set new release no</h5>');	
$database->simple_query('UPDATE `'.TABLE_PREFIX.'settings` SET `value` =\'4.2.0\' WHERE `name`=\'lepton_version\'');
if($database->is_error()) {
	echo LEPTON_tools::display( $database->get_Error() , "div", "ui message red");
} else {
	echo "<h3>update to LEPTON 4.2.0 successfull!</h3><br />"; 
}

?>
