<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          wysiwyg
 * @author          Ryan Djurovich
 * @author          LEPTON Project
 * @copyright       2004-2010 WebsiteBaker Project
 * @copyright       2010-2020 LEPTON Project 
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

class wysiwyg extends LEPTON_abstract
{
    // Own instance for this class!
    static $instance;

    public $wysiwyg_editor_loaded = false;
    
    public $got_wysiwyg_editor = true;
    
    /**
     *  Holds a linear list with all section-id with type "wysiwyg" of the currend page.
     *  @var array 
     */
    public $allSectionIDs = array();
    
    public function initialize() 
    {
    
        if (!defined('WYSIWYG_EDITOR') OR WYSIWYG_EDITOR=="none" OR !file_exists(LEPTON_PATH.'/modules/'.WYSIWYG_EDITOR.'/include.php'))
        {
            $this->got_wysiwyg_editor = false;
            
            if(!function_exists("show_wysiwyg_editor"))
            {
                function show_wysiwyg_editor( $name, $id, $content, $width, $height, $promt=true )
                {
                    $sHTML = '<textarea name="'.$name.'" id="'.$id.'" style="width: '.$width.'; height: '.$height.';">'.$content.'</textarea>';
                
                    if( true === $promt)
                    {
                        echo $sHTML;
                    } else {
                        return $sHTML;
                    }
                }
            }
        } else {
        
            global $page_id;
            $iTempPageID = (isset($page_id))
                ? $page_id
                : (defined("PAGE_ID") ? PAGE_ID : 0 )
                ;
            
            $this->allSectionIDs = array();
               
            $all_sections = array();
            LEPTON_database::getInstance()->execute_query(
                "SELECT `section_id` FROM `".TABLE_PREFIX."sections` WHERE `page_id`= '".$iTempPageID."' AND `module`= 'wysiwyg' order by `position`",
                true,
                $all_sections,
                true
            );
            foreach($all_sections as $wysiwyg_section) {
                $this->allSectionIDs[] = abs(intval($wysiwyg_section['section_id']));
            }

            // At last we call the "include.php" of the current wysiwyg editor
            require_once LEPTON_PATH.'/modules/'.WYSIWYG_EDITOR.'/include.php';
        }
    }
}