<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2018 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);

echo ('<h3>Current process : updating to LEPTON 4.1.0</h3>');

// modify addon entry
echo ('<h5>Current process : alter groups table, add field</h5>');	
$database->simple_query('ALTER TABLE `'.TABLE_PREFIX.'groups` ADD `backend_permission` BOOLEAN NOT NULL DEFAULT TRUE AFTER `language_permissions`');
if($database->is_error()) {
	echo LEPTON_tools::display( $database->get_Error() , "div", "ui message red");
} else {
	echo ('<h5>Current process : alter table successful</h5>');	
}

// [1.0] add secure vars
echo ('<h5>Current process : add secure vars</h5>');	
require_once LEPTON_PATH.'/framework/functions/function.random_string.php';
$filename = LEPTON_PATH.'/config/lepton.ini.php';

$aTempConfig = parse_ini_string(";".file_get_contents($filename), true );

// [1.1] setting the base values
if(function_exists('openssl_cipher_iv_length')) {
	$db_key = sprintf('%04x%04x%04x%04x%04x%04x%04x%04x', mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0x0fff) | 0x4000, mt_rand(0, 0x3fff) | 0x8000, mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff));
	$cipher = 'AES-256-CBC';
	$ivlen = openssl_cipher_iv_length($cipher);
	$iv = random_string($ivlen,'pass');	
} 
else
{
	$db_key = sprintf('%04x%04x%04x%04x%04x%04x%04x%04x', mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0x0fff) | 0x4000, mt_rand(0, 0x3fff) | 0x8000, mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff));
	$cipher = 'AES-256-CBC';
	$ivlen = 16;	
	$iv = random_string($ivlen,'pass');
	
}

// [1.2] looking for the values
$sIniAddition = "";

// [1.2.1]
if(!isset($aTempConfig['database']['mode']))
{
    $sIniAddition .= "
mode = 'STRICT_ALL_TABLES'";
}

// [1.2.2]
if(!isset($aTempConfig['database']['key']))
{
    $sIniAddition .= "
key = '".$db_key."'";
}

// [1.2.3]
if(!isset($aTempConfig['database']['cipher']))
{
    $sIniAddition .= "
cipher = '".$cipher."'";
}

// [1.2.4]
if(!isset($aTempConfig['database']['iv']))
{
    $sIniAddition .= "
iv = '".$iv."'";
}

// [1.2.5]
if(!isset($aTempConfig['database']['options']))
{
    $sIniAddition .= "
options = '0'";
}

// [1.3.0]
if ( (strlen($sIniAddition) > 0) && (is_writable($filename) ) )
{
    if (!$handle = fopen($filename, "a")) {
        echo('Cannot open file!'); 
    }

    if (!fwrite($handle, $sIniAddition)) {
         echo('Cannot write into file!'); 
    }

    fclose($handle);
	echo ('<h5>Current process : add secure vars successful.</h5>');	

} else 
{
   echo ("<h5>Current process : add secure vars ". ( (strlen($sIniAddition) > 0) ? "failed!" : "not needed" )."</h5>");	
}

//  [1] ---- Update group preferences
echo '<h5>Current process : run group preferences permissions upgrade.php</h5>';  

$aTempGroupsToUpdate = array();
$database->execute_query(
    "SELECT `system_permissions`,`group_id` FROM `".TABLE_PREFIX."groups` WHERE `group_id`=1 OR `backend_permission`=1",
    true,
    $aTempGroupsToUpdate,
    true
);
foreach( $aTempGroupsToUpdate as $aTempGroupInfo )
{
    $aTempArray = explode(",", $aTempGroupInfo['system_permissions']);
    if(!in_array("preferences", $aTempArray))
    {
        $aTempArray[] = "preferences";
    }
    if(!in_array("preferences_access", $aTempArray))
    {
        $aTempArray[] = "preferences_access";
    }
    $database->simple_query("UPDATE `".TABLE_PREFIX."groups` set `system_permissions`='".(implode(",", $aTempArray))."' WHERE `group_id`=".$aTempGroupInfo['group_id']);
}

echo ('<h5>Current process : group preferences permissions successful</h5>');	
//  [1] ---- End
 
echo '<h5>Current process : run modules upgrade.php</h5>';  
		 
$module_names = array(
	"captcha_control",
	"code2",
	"droplets",
	"lib_jquery",	
	"lib_lepton",	
	"lib_search",			
	"lib_semantic",			
	"lib_twig",	
	"menu_link",
	"news",
	"quickform",		
	"tinymce"
);
LEPTON_handle::upgrade_modules($module_names);

echo "<h5>run upgrade.php of modified modules: successfull</h5>";

		
echo '<h5>reload all addons</h5>';
		
if (file_exists (LEPTON_PATH.'/install/update/reload.php')) {
		require_once(LEPTON_PATH . '/install/update/reload.php');
}	
		
echo "<h5>reload all addons: successfull</h5>";

// update release and success message
echo ('<h5>Current process : set new release no</h5>');	
$database->simple_query('UPDATE `'.TABLE_PREFIX.'settings` SET `value` =\'4.1.0\' WHERE `name`=\'lepton_version\'');
if($database->is_error()) {
	echo LEPTON_tools::display( $database->get_Error() , "div", "ui message red");
} else {
	echo "<h3>update to LEPTON 4.1.0 successfull!</h3><br />"; 
}

?>
