<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          Website Baker Project, LEPTON Project
 * @copyright       2004-2010 Website Baker Project
 * @copyright       2010-2020 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */


// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php


	if ( false === isset($_SESSION['captcha_time']))
	{
		die(header("Location: ../index.php"));
	}


// includes
include( LEPTON_PATH . "/modules/captcha_control/functions/function.create_ttf_image.php" );


// Captcha
	// check section & page
	$section_id = $_SESSION[ 'captcha_id' ];
	$page_id = 0;
	if ( array_key_exists( "PAGE_ID", $_SESSION ))
		{ $page_id = $_SESSION['PAGE_ID']; }

	// get a captcha
	$_SESSION['captcha' . $section_id] = '';
	$captcha = get_captcha( "random" );
	$_SESSION['captcha' . $section_id] = $captcha[ "RESULT" ];
	$_SESSION['captcharequest' . $section_id] = $captcha;

	// create Captcha image
	$image = create_ttf_image( $page_id, $section_id, $captcha, __DIR__ );

	// create reload image
	$reload = ImageCreateFromPNG(__DIR__ . "/images/reload_140_40.png" ); // reload-overlay

	imagealphablending($reload, TRUE);
	imagesavealpha($reload, TRUE);

	// overlay
	imagecopy($reload, $image, 0,0,0,0, 140,40);
	imagedestroy($image);
	$image = $reload;

	// define header
	header("Expires: Mon, 1 Jan 1990 05:00:00 GMT");
	header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate, proxy-revalidate");
	header("Pragma: no-cache");
	header("Content-type: image/png");

	// prepare output
	ob_start();
	imagepng($image);
	header("Content-Length: ".ob_get_length()); 
	ob_end_flush();
	imagedestroy($image);


?>
