<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          wrapper
 * @author          WebsiteBaker Project
 * @author          LEPTON Project
 * @copyright       2004-2010 WebsiteBaker Project
 * @copyright       2010-2020 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

// get own module class and template-engine.
$oWR = wrapper::getInstance();

$oTwig = lib_twig_box::getInstance();
$oTwig->registerModule('wrapper');

// Get values from the DB
$data = array();
$database->execute_query(
	"SELECT * FROM ".TABLE_PREFIX."mod_wrapper WHERE section_id = '".$section_id."' ",
	true,
	$data,
	false
);

// Append notice-message to the data-array
$data['wrappernotice'] = $oWR->language['NOTICE'];

echo $oTwig->render( 
	"@wrapper/view.lte",	//	template-filename
	$data				//	template-data
);

?>