<?php
 
/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2021 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */ 
 
class init_page
{
	public $title= "Hello World";
	
	public $section_type = "wrapper";
	
	public $file_content = '';
	
	public $file_name = "Hello-World.php";
	
	public $language = "EN";
	
	public $url="https://doc.lepton-cms.org/_packinstall/start-package3.html";
	
	private $db = NULL;
	
	private $errors = array();
	
	private $query_str = "";
	
	public function __construct() 
	{
		$this->db = LEPTON_database::getInstance();
		
		$this->file_content  = '
<?php
/**
 *	This file is autogenerated by LEPTON installer
 *	Do not modify this file!
 */
	$page_id = 1;
	require_once(\'../index.php\');
?>
';
	}

	public function build_page() {
		$fp = fopen("../".PAGES_DIRECTORY."/hello-world.php", 'w');
		if ($fp) {
			fwrite($fp, $this->file_content);
			fclose($fp);
		}
		
		$values = array(
			'page_id' => 1,
			'position' => 1,
			'module' => "wrapper",
			'block'	=> 1
		);
		
		$this->db->simple_query("INSERT into `".TABLE_PREFIX."sections` (`".(implode("`,`", array_keys($values)))."`) VALUES ('".(implode("','", array_values($values)))."') ");
		$this->__test_error();
		
		$values = array(
			'section_id' => 1,
			'page_id' => 1,
			'url' =>  $this->url,
			'height' => "900"
		);
		
		$this->db->simple_query("INSERT into `".TABLE_PREFIX."mod_wrapper` (`".(implode("`,`", array_keys($values)))."`) VALUES ('".(implode("','", array_values($values)))."') ");
		$this->__test_error();
		
		$values = array(
			'link'	=> "/hello-world",
			'page_title' => "hello world",
			'menu_title' => "hello world",
			'page_trail' => 1,
			'root_parent' => 1,
			'searching' => 1,
			'admin_groups' => 1,
			'viewing_groups' => 1,
			'modified_by' => 1,
			'modified_when' => TIME(),
			'language' => $this->language,
			'visibility' => 'public',
			'menu' => '1',
			'target' => '_self',
		  'description' => '',
		  'keywords' => '',
		  'admin_users' => '',
		  'viewing_users' => ''
		);
		
		$this->db->simple_query("INSERT into `".TABLE_PREFIX."pages` (`".(implode("`,`", array_keys($values)))."`) VALUES ('".(implode("','", array_values($values)))."') ");
		$this->__test_error();
	}
	
	private function __test_error() {
		if(true == $this->db->is_error())
		{
			die("class init_page - error: <b>".$this->db->get_error());
		}
	}

}
?>