<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2021 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);

echo ('<h3>Current process: updating to LEPTON 5.1.0</h3>');



echo '<h5>Current process: delete not needed files and directories</h5>';
// [1] files
$file_names = array(
	'/framework/functions/function.switch_theme.php'
);
LEPTON_handle::delete_obsolete_files( $file_names );
echo "<h5>Delete not needed files and directories: successfull</h5>";


// create a htaccess protected secure directory
echo '<h5>Current process: create secure directory</h5>';
if(!file_exists(LEPTON_PATH.'/temp/secure'))
{
	mkdir(LEPTON_PATH.'/temp/secure');
} 

if(!file_exists(LEPTON_PATH.'/temp/secure/.htaccess'))
{
	$htuser = $database->get_one("SELECT username FROM ".TABLE_PREFIX."users WHERE user_id = 1");
	if($htuser == NULL)
	{
		$htuser = 'lepadmin';
	}
	$random_value = random_int(100000,999999);
	$password = sha1($random_value);
	$htpassword = '{SHA}'.$password;

$htcontent = "# .htaccess-Datei
AuthType Basic
AuthName 'Protected area - Please insert password!'
AuthUserFile ".LEPTON_PATH."/temp/secure/.htpasswd
require user ".$htuser."
";
	
$htpwcontent = "# Password file, user:".$htuser.", password: ".$random_value."
".$htuser.":".$htpassword."
";
	
	file_put_contents(LEPTON_PATH.'/temp/secure/.htaccess',$htcontent);
	file_put_contents(LEPTON_PATH.'/temp/secure/.htpasswd',$htpwcontent);
}
echo "<h5>create secure directory: successfull</h5>";


// install new modules
echo '<h5>Current process: run modules install.php</h5>';
$module_names = array(
//	"lib_comp"
);
LEPTON_handle::install_modules($module_names);
echo "<h5>run install.php of new modules: successfull</h5>";


// upgrade updated modules
echo '<h5>Current process: run modules upgrade.php</h5>';
$module_names = array(
	"addon_info",
	"code2",
	"droplets",
	"lib_lepton",
	"lib_jquery",
	"lib_phpmailer",
	"lib_r_filemanager",
	"lib_twig",
	"news",
	"quickform",
	"tinymce",
	"wrapper",
	"wysiwyg",
	"wysiwyg_admin"
);
LEPTON_handle::upgrade_modules($module_names);
echo "<h5>run upgrade.php of modified modules: successfull</h5>";


// update release and success message
echo ('<h5>Current process: set new release number</h5>');
$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='5.1.0' WHERE name = 'lepton_version' ");
echo "<h3>update to LEPTON 5.1.0 successfull!</h3><br />";
