<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2021 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */


// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

// Get lists of backgrounds and choose a random one
function get_background( $page_id, $section_id, $dir )
{
	global $database;

	$lookups = array();

	// check on the actual frontend template.
	$template = "";
	if ( $page_id > 0 )
	{
		$template = $database->get_one("SELECT `template`"
											. " from `".TABLE_PREFIX."pages`"
											. " where `page_id`= '" . $_SESSION['PAGE_ID'] . "'");
		if ( false === empty( $template ))
			{ $lookups[] = LEPTON_PATH . "/templates/" . $template . "/frontend/captcha_control/backgrounds/"; }
	}
	
	// check on default template
	if ( $template != DEFAULT_TEMPLATE )
		{ $lookups[] = LEPTON_PATH . "/templates/" . DEFAULT_TEMPLATE . "/frontend/captcha_control/backgrounds/"; }

	// check on input DIR
	if ( false === empty( $dir ))
		{ $lookups[] = $dir . "/backgrounds/"; }

	// check on module DIR
	$lookups[] = LEPTON_PATH . "/modules/captcha_control/captcha/backgrounds/";

	// loop on path till first found, than return list of content
	$backgrounds = array();
	foreach( $lookups as $path )
	{
		if ( is_dir( $path ))
		{
			$backgrounds = glob( $path . "*.png" );
			break;
		}
	}

	// prepare return
	$background = "";
	if ( count( $backgrounds ) > 1 )
		{ $background = $backgrounds[ array_rand( $backgrounds ) ]; }
	elseif ( count( $backgrounds ) == 1 )
		{ $background = $backgrounds[ 0 ]; }

	return $background;
}

?>
