<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2021 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */


// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

// Get lists of fonts and choose a random one
function get_font( $dir )
{
	$lookups = array();

	// check on input DIR
	if ( false === empty( $dir ))
    {
        $lookups[] = $dir . "/fonts/";
    }

	// Check on LEPTON-CMS (since L* V)
	$lookups[] = LEPTON_PATH . "/modules/lib_lepton/fonts/";

	// loop on path till first found, than return list of content
	$fonts = array();
	foreach( $lookups as $path )
	{
		if ( is_dir( $path ))
		{
			$fonts = glob( $path . "*.ttf" );
			break;
		}
	}

	// prepare return
	$font = "";
	if ( count( $fonts ) > 1 )
    {
        $font = $fonts[ array_rand( $fonts ) ];
    }
	elseif ( count( $fonts ) == 1 )
	{
	    $font = $fonts[ 0 ];
	}

	return $font;
}
