<?php

/**
 *
 * @module          initial_page
 * @author          LEPTON project 
 * @copyright       2010-2021 LEPTON Project 
 * @link            https://lepton-cms.org
 * @license         copyright, all rights reserved
 * @license_terms   please see info.php of this module
 *
 */
 
 // include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

//  [1] install table
$table_fields="
    `id` int NOT NULL AUTO_INCREMENT,
    `user_id` INT(11) NOT NULL DEFAULT '1',
    `init_page` TEXT NOT NULL,
    `page_param` VARCHAR(255) NOT NULL DEFAULT '',	
    PRIMARY KEY ( `id` )
    ";

LEPTON_handle::install_table("mod_initial_page", $table_fields);

//  [2] insert values
$field_values="
    (NULL, '1', 'start/index.php', '')
";

LEPTON_handle::insert_values("mod_initial_page", $field_values);	
