<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          menu-link
 * @author          WebsiteBaker Project, LEPTON Project
 * @copyright       2004-2010 WebsiteBaker Project
 * @copyright       2010-2021 LEPTON Project 
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php


$oMENU_LINK = menu_link::getInstance();

//  Patch
$MOD_MENU_LINK = $oMENU_LINK->language;

//  Settings
$aSettings = array();
$database->execute_query(
    "SELECT * FROM `". TABLE_PREFIX. "mod_menu_link` WHERE `section_id` = ".$section_id,
    true,
    $aSettings,
    false
);

if(0 == count($aSettings))
{
    LEPTON_admin::getInstance()->print_error("Fatal: no settings found!");
}

$target_page_id = $aSettings['target_page_id'];
$r_type = $aSettings['redirect_type'];
$extern = $aSettings['extern'];
$anchor = $aSettings['anchor'];
$sel = ' selected="selected"';

// Get list of all visible pages and build a page-tree

// this function will fetch the page_tree, recursive
if(!function_exists('menulink_make_tree')) {
    function menulink_make_tree($parent, $link_pid, $tree) {
        global $database, $admin, $menulink_titles;
        
        $aPages = array();
        $database->execute_query(
            "SELECT * FROM `".TABLE_PREFIX."pages` WHERE `parent`=$parent ORDER BY `position`",
            true,
            $aPages,
            true
        );
        foreach($aPages as $page)
        {
            if($admin->page_is_visible($page) )
            {
                $pids = explode(',', $page['page_trail']);
                $entry = '';
                foreach($pids as $pid)
                {
                    $entry .= $menulink_titles[$pid].' / ';
                }
                $tree[$page['page_id']] = rtrim($entry, '/ ');
                $tree = menulink_make_tree($page['page_id'], $link_pid, $tree);
            }
        }
        
        return($tree);
    }
}

// get list of all page_ids and page_titles
global $menulink_titles;
$menulink_titles = array();
$table_p = TABLE_PREFIX."pages";
$aPages = array();
$database->execute_query(
    "SELECT `page_id`,`menu_title` FROM `".TABLE_PREFIX."pages`",
    true,
    $aPages,
    true
);
foreach($aPages as $page)
{
    $menulink_titles[$page['page_id']] = $page['menu_title'];
}
// now get the tree
$links = array();
$links = menulink_make_tree(0, $page_id, $links);

// Get list of targets (id=... or <a name ...>) from pages in $links
$targets = array();
$table_mw = TABLE_PREFIX."mod_wysiwyg";
$table_s = TABLE_PREFIX."sections";
foreach($links as $pid=>$l) {
	$aAllSections = [];
	$bResult = $database->execute_query(
	    "SELECT `section_id`, `module` FROM `".$table_s."` WHERE `page_id` = '".$pid."' ORDER BY `position`",
	    true,
	    $aAllSections,
	    true
	);
	
	if(true === $bResult)
	{
        foreach($aAllSections as $section)
        {
			// get section-anchor
			if(defined('SEC_ANCHOR') && SEC_ANCHOR!='') {
				$targets[$pid][] = SEC_ANCHOR.$section['section_id'];
			} else {
				$targets[$pid] = array();
			}
			if($section['module'] == 'wysiwyg') {
				if($page_content = $database->get_one("SELECT `content` FROM `".$table_mw."` WHERE `section_id` = '".$section['section_id']."' LIMIT 1"))
				{
					// $page = $query_page->fetchRow();
					if(preg_match_all('/<(?:a[^>]+name|[^>]+id)\s*=\s*"([^"]+)"/i',$page_content, $match))
					{
					    foreach($match[1] AS $t)
					    {
						    $targets[$pid][$t] = $t;
						}
					}
				}
			}
		}
	}
}
// get target-window for actual page
$target = $database->get_one("SELECT `target` FROM `".TABLE_PREFIX."pages` WHERE page_id = ".$page_id );

// script for target-select-box, div prevents js code from being displayed in lepsem backend
?>
<div>
<script language="JavaScript" type="text/javascript">
/*<![CDATA[*/
	function populate() {
		o=document.getElementById('menu_link');
		d=document.getElementById('page_target');
		e=document.getElementById('extern');
		if(!d){return;}
		var mitems=new Array();
		mitems['0']=[' ','0'];
		mitems['-1']=[' ','0'];
<?php

		foreach($links AS $pid=>$link)
		{
			$str="mitems['$pid']=[";
			$str.="' ',";
			$str.="'0',";
			if(isset($targets[$pid]))
			{
                if(is_array($targets) && is_array($targets[$pid]))
                {
                    foreach($targets[$pid] AS $value)
                    {
                        $str.="'#$value',";
                        $str.="'$value',";
                    }
                    $str=rtrim($str, ',');
                }
			}
			$str.="];\n";
			echo $str;
		}
?>
		d.options.length=0;
		cur=mitems[o.options[o.selectedIndex].value];
		if(!cur){return;}
		d.options.length=cur.length/2;
		j=0;
		for(var i=0;i<cur.length;i=i+2)
		{
			d.options[j].text=cur[i];
			d.options[j++].value=cur[i+1];
		}

    if(o.value=='-1') {
			e.style.display = "inline-block";
		} else {
			e.style.display = "none";
		}
	}

/*]]>*/
</script>
</div>
<div class="module_menu_link">
<form name="menulink" action="<?php echo LEPTON_URL ?>/modules/menu_link/save.php" method="post">
<input type="hidden" name="page_id" value="<?php echo $page_id ?>" />
<input type="hidden" name="section_id" value="<?php echo $section_id ?>" />
<table>
<tr>
	<td>
		<?php echo $TEXT['LINK'].':' ?>
	</td>
	<td>
		<select name="target_page_id" id="menu_link" onchange="populate()" style="width:250px;" >
			<option value="0"<?php echo $target_page_id=='0'?$sel:''?>><?php echo $TEXT['PLEASE_SELECT']; ?></option>
			<option value="-1"<?php echo $target_page_id=='-1'?$sel:''?>><?php echo $MOD_MENU_LINK['EXTERNAL_LINK']; ?></option>
			<?php foreach($links AS $pid=>$link) {
				if ($pid == $page_id)  // Display current page with selection disabled
					echo "<option value=\"$pid\" disabled=\"disabled\">$link *</option>\n";
				else
					echo "<option value=\"$pid\" ".($target_page_id==$pid?$sel:'').">$link</option>\n";
			} ?>
		</select>
		&nbsp;
		<input type="text" name="extern" id="extern" placeholder="https://" value="<?php echo ($target_page_id == '-1' ? $extern : ""); ?>" style="width:250px;" <?php if($target_page_id != '-1') echo "class='hide'"; ?> />
	</td>
</tr>
<tr>
	<td>
		<?php echo $TEXT['ANCHOR'].':' ?>
	</td>
	<td>
		<select name="anchor" id="page_target" onfocus="populate()" style="width:250px;">
			<option value="<?php echo $anchor ?>" selected="selected"><?php echo $anchor=='0'?' ':'#'.$anchor ?></option>
		</select>
	</td>
</tr>
<tr>
	<td class="link_target">
		<?php echo $TEXT['TARGET'].':' ?>
	</td>
	<td class="link_target">
		<select name="target" style="width:250px;" >
			<option value="_blank"<?php if($target=='_blank') echo ' selected="selected"'; ?>><?php echo $TEXT['NEW_WINDOW'] ?></option>
			<option value="_self"<?php if($target=='_self') echo ' selected="selected"'; ?>><?php echo $TEXT['SAME_WINDOW'] ?></option>
			<option value="_top"<?php if($target=='_top') echo ' selected="selected"'; ?>><?php echo $TEXT['TOP_FRAME'] ?></option>
		</select><br />
		<div class="info"><?php echo $MOD_MENU_LINK['XHTML_EXPLANATION'] ?></div>
	</td>
</tr>
<tr>
	<td class="r_type" style="vertical-align: top;">
		<?php echo $MOD_MENU_LINK['R_TYPE'].':' ?>
	</td>
	<td>
		<select class="r_type" name="redirect_type" style="width:250px;" >
			<option value="301"<?php if($r_type=='301') echo ' selected="selected"'; ?>>301 (Moved permanently)</option>
			<option value="302"<?php if($r_type=='302') echo ' selected="selected"'; ?>>302 (Moved temporarily)</option>
		</select><br /><br />
		<div class="ui info message" style="background-position:top left;"><?php echo $MOD_MENU_LINK['REDIRECT_EXPLANATION']; ?></div>
	</td>
</tr>
</table>

<br />

<table cellpadding="0" cellspacing="0" border="0" width="100%">
<tr>
	<td align="left">
		<input class="lepsem_submit" type="submit" value="<?php echo $TEXT['SAVE'] ?>" style="width: 100px; margin-top: 5px;" />
		<input class="reset" type="button" value="<?php echo $TEXT['CANCEL'] ?>" onclick="javascript: window.location = 'index.php';" style="width: 100px; margin-top: 5px;" />
	</td>
</tr>
</table>

</form>
</div>