<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2021 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);

echo ('<h3>Current process: updating to LEPTON 5.2.0</h3>');



echo '<h5>Current process: delete not needed files and directories</h5>';
// [1] directories
$directory_names = array(
	'/search'
);
LEPTON_handle::delete_obsolete_directories( $directory_names );

// [2] files
$file_names = array(
//	'/framework/functions/function.switch_theme.php'
);
LEPTON_handle::delete_obsolete_files( $file_names );
echo "<h5>Delete not needed files and directories: successfull</h5>";

echo '<h5>Current process: create new passwordfiles</h5>';
LEPTON_handle::restoreStandardProtection();
echo "<h5>Create new passwordfiles: successfull</h5>";
	
// install new modules
echo '<h5>Current process: run modules install.php</h5>';
$module_names = array(
//	"lib_comp"
);
LEPTON_handle::install_modules($module_names);
echo "<h5>run install.php of new modules: successfull</h5>";


// upgrade updated modules
echo '<h5>Current process: run modules upgrade.php</h5>';
$module_names = array(
	"code2",
	"droplets",
	"edit_area",
	"lib_fomantic",
	"lib_jquery",
	"lib_lepton",
	"lib_phpmailer",
	"lib_r_filemanager",
	"lib_search",
	"lib_twig",
	"news",
	"quickform",
	"show_menu2",
	"tinymce",
	"wysiwyg_admin"
);
LEPTON_handle::upgrade_modules($module_names);
echo "<h5>run upgrade.php of modified modules: successfull</h5>";


// update release and success message
echo ('<h5>Current process: set new release number</h5>');
$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='5.2.0' WHERE name = 'lepton_version' ");
echo "<h3>update to LEPTON 5.2.0 successfull!</h3><br />";
