<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          Website Baker Project, LEPTON Project
 * @copyright       2004-2010 Website Baker Project
 * @copyright       2010-2021 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php


/* ------------------------------
 *
 * Note:
 * *****
 *
 * Normally, the captcha creation & validation should be called directly.
 * However, modules might not have been adapted and still use old call.
 * With this script, we support this old behaviour.
 *
 * Also note that in old behaviour, google recaptcha was not supported 
 * in previous captcha_control module!
 *
 * ------------------------------
 */


function call_captcha( $action, $style, $section_id )
{
	// set default params
	$params = array(
		 "ACTION"		=> $action
		,"SECTION_ID"	=> $section_id
	);

	// set - based on old logic - action specific styles
	switch( $action )
	{
		case "image":
			$params[ "IMAGE_ATTR" ]	= $style;
			break;
		case "image_iframe":
			if ( CAPTCHA_TYPE != "calc_text" )
				{ $params[ "IMAGE_ATTR" ]	= $style; }
			break;
		case "input":
			$params[ "INPUT_ATTR" ]	= $style;
			break;
		case "text":
			$params[ "TEXT_ATTR" ]	= $style;
			break;
	}

	// get instance of captcha plugin
	require_once(LEPTON_PATH . "/modules/captcha_control/classes/captcha.php" );
	$oCAPTCHA = captcha::getInstance();

	// build the captcha
	echo $oCAPTCHA->build_captcha( $params );
}
