<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 * 
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2021 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */


// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php


// Evaluate the captcha
function get_captcha( $kind, $length = 5, $type = "alphanum" )
{
	// init
	$captcha = array();

	// evaluate captcha
	switch( $kind )
	{
		case "calc":
			mt_srand((double)microtime()*1000000);
			$n = mt_rand(1,4);
			switch( $n )
			{
				case 1:
					$x = mt_rand(1,13);
					$y = mt_rand(1,9);
					$captcha = array( "RESULT" => $x + $y, "CAPTCHA" => "$x+$y" );
					break; 
				case 2:
					$x = mt_rand(11,31);
					$y = mt_rand(1,10);
					$captcha = array( "RESULT" => $x - $y, "CAPTCHA" => "$x-$y" );
					break;
				case 3:
					$x = mt_rand(3,10);
					$y = mt_rand(2,7);
					$captcha = array( "RESULT" => $x * $y, "CAPTCHA" => "$x*$y" );
					break;
				default:
					$x = mt_rand(3,10);
					$y = mt_rand(2,7);
					$z = $x * $y;
					$captcha = array( "RESULT" => $y, "CAPTCHA" => "$z/$x" );
					break;
			}

			// get captcha instance
			require_once(LEPTON_PATH . "/modules/captcha_control/classes/captcha.php" );
			$oCAPTCHA = captcha_control::getInstance();

			// define calculation translations for speech
			$trans = array(	"+" => " " . $oCAPTCHA->language[ 'ADD' ] . " ",
							"-" => " " . $oCAPTCHA->language[ 'SUBTRACT' ] . " ",
							"*" => " " . $oCAPTCHA->language[ 'MULTIPLY' ] . " ",
							"/" => " " . $oCAPTCHA->language[ 'DIVIDE' ] . " "
						);
			$captcha[ "SPEECH" ] = strtr( $captcha[ "CAPTCHA" ], $trans );
			break;

		case "random":
			require_once( LEPTON_PATH."/framework/functions/function.random_string.php");
			$string = random_string($length, $type ); 
			$captcha = array( "RESULT" => $string, "CAPTCHA" => $string );

			// split a string into single elements for speech
			$captcha[ "SPEECH" ] = implode(" ", str_split( $string ));
			break;
	}

	return $captcha;
}

?>
