/**
 * plugin.js
 *
 * Copyright, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/** [1]
var dropletsvalues = [
{ text:'check-css', value:'check-css'},
{ text:'EditThisPage', value:'EditThisPage'},
{ text:'year', value:'year'},
{ text:'EmailFilter', value:'EmailFilter'},
{ text:'LoginBox', value:'LoginBox'},
{ text:'Lorem', value:'Lorem'},
{ text:'Aldus', value:'aldus' }
];
**/

tinymce.ScriptLoader.load(tinyMCE.baseURL + '/plugins/droplets/droplets.php');

tinymce.PluginManager.add('droplets', function(editor, url) {
	var win;
	
    // Add a button that opens a window
    editor.addButton('droplets', {
       /* text: 'Droplets', */
        icon: 'droplets', // false // # this is a css identifier!
        tooltip: "Insert Droplet",
        onclick: function() {
            // Open window
           win= editor.windowManager.open({
                title: 'Droplets',
				width: 400,
                height: 300,
                body: [
                   // {type: 'textbox', name: 'title', label: 'Title'},
                    {
                    	type: 'listbox',
                    	name: 'dropletselect',
                    	label: 'select Droplet',
                    	values: dropletsvalues, // siehe [1]
                    	onselect: function(e) {
								var m = dropletsinfo.length;
								for(var i=0; i<m; i++) {
									if (dropletsinfo[i].text == e.control.value() ) {
										win.find('#info').value( dropletsinfo[i].comment );
										win.find('#desc').value( dropletsinfo[i].desc );
									}
								}
							}
					},
                    {
                    	type: 'textbox',
                    	name: 'dropletattributes',
                    	label: 'Params'
                    },
                    {
                    	type: 'textbox',
                    	name: 'desc',
                    	label: 'Description',
                    	multiline: true,
                    	disabled: true,
                    	style: "color:#990000;height:50px;font-family:Verdana, sans-serif; font-size:12px;line-height:1.3em;",
                    	value: dropletsinfo[0].desc // first entry of the dropletsinfo
                    },
                    {
                    	type: 'textbox',
                    	name: 'info',
                    	label: 'Information',
                    	multiline: true,
                    	disabled: true,
                    	style: "color:#990000;height:100px;font-family:Verdana, sans-serif; font-size:12px;line-height:1.3em;",
                    	value: dropletsinfo[0].comment // first entry of the dropletsinfo
                    }
                ],
                onsubmit: function(e) {
                	var temp_attrib = (e.data.dropletattributes == "") ? "" : "?"+e.data.dropletattributes;
                	
                    // Insert content when the window form is submitted
                    editor.insertContent(/*'Title: ' + */'[[' + e.data.dropletselect + temp_attrib + ']]');
                }
            });
        }
    });

    // Adds a menu item to the tools menu
    /*
    editor.addMenuItem('droplets', {
        text: 'Droplets',
        context: 'insert',
        onclick: function() {
            // Open window with a specific url
            editor.windowManager.open({
                title: 'Droplets',
                url: url+'/droplets.php',//'http://www.tinymce.com', // here the dialog
                width: 300,
                height: 300,
                buttons: [{
                    text: 'Close',
                    onclick: 'close'
                }]
            });
        }
    });
    */
});