<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 *
 * @author          Thomas Hornik (thorn),LEPTON Project
 * @copyright       2008-2010, Thomas Hornik (thorn)
 * @copyright       2010-2021  LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

// -------------------------------------------
// delete obsolete files in current version
$file_names = array(
	'/modules/captcha_control/languages/NO.php',				// language not supported by LEPTON
	'/modules/captcha_control/languages/SK.php',				// language not supported by LEPTON
	'/modules/captcha_control/backend.css',						// old & obsolete
	'/modules/captcha_control/frontend.css',					// moved to css folder
	'/modules/captcha_control/captcha/reload_120_30.png',		// moved to related plugin
	'/modules/captcha_control/captcha/reload_140_40.png',		// moved to related plugin
	'/modules/captcha_control/captcha/readme.txt'				// moved into LEPTON documention
);

LEPTON_handle::delete_obsolete_files($file_names);

$dir_names = array(
	'/modules/captcha_control/captcha/fonts',					// moved to lib_lepton
	'/modules/captcha_control/captcha/captchas',				// moved to plugins
	'/templates/lepsem/backend/captcha_control'					// no longer required
);
LEPTON_handle::delete_obsolete_directories($dir_names);

// check the content of text
$database = LEPTON_database::getInstance();
	// get questions and answers
	$text_ct = $database->get_one("SELECT ct_text FROM ".TABLE_PREFIX."mod_captcha_control ");
	
	// process only if not empty, not already a json and also not default example
	if (( false === is_null( $text_ct )) 
	 && ( false === empty( $text_ct ))
	 && ( "{" != substr( $text_ct, 0, 1 ))
	 && ( !preg_match('/### .*? ###/', $text_ct )))
	{
		$settings = array();
		$max = array();

		// transform old content into new json format
		$content = explode("\n", $text_ct);

		reset( $content );
		while( $s = current($content))
		{
			// get question
			$s=trim(rtrim(rtrim($s,"\n"),"\r")); // remove newline
			if($s=='' OR $s[0] !='?') {
				next($content);
				continue;
			}
			if(isset($s[3]) && $s[3] ==':')
			{
				$lang=substr($s,1,2);
				$q=substr($s,4);
			} else
			{
				$lang='XX';
				$q=substr($s,1);
				if($q=='')
				{
					next($content);
					continue;
				}
			}

			// get answer
			$s=next($content);
			$s=trim(rtrim(rtrim($s,"\n"),"\r")); // remove newline
			if(isset($s[0]) && $s[0] =='!') {
				$a=substr($s,1);

				// prepare array for save
				if ( false === array_key_exists( $lang, $max ))
					{ $max[ $lang ] = 0; }
				$max[ $lang ]++;
				$settings[ $lang . "_question_" . $max[ $lang ] ] = $q;
				$settings[ $lang . "_answer_" . $max[ $lang ] ]   = $a;

				next($content);
			}
		}

		// set number of questions
		$c = 0;
		foreach( $max as $lang => $i )
		{
			if ( $i > $c )
			{ 
				$c = $i;
				$settings[ "nbr_questions"] = $c;
			}
		}

		$final[ "text" ] = $settings;

		// update database
		$database->build_and_execute(
			"UPDATE"
			,TABLE_PREFIX . "mod_captcha_control"
			,array( "ct_text" => json_encode( $final ) )
			,""
		);
	}

?>
