<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          wysiwyg
 * @author          LEPTON Project
 * @copyright       2010-2021 LEPTON Project 
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if (defined('LEPTON_PATH')) {	
	include(LEPTON_PATH.'/framework/class.secure.php'); 
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.'/framework/class.secure.php'))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.'/framework/class.secure.php')) { 
		include($root.'/framework/class.secure.php'); 
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

function wysiwyg_search($func_vars) {
	extract($func_vars, EXTR_PREFIX_ALL, 'func');
	static $search_sql = FALSE;
	if(function_exists('search_make_sql_part')) {
		if($search_sql===FALSE)
			$search_sql = search_make_sql_part($func_search_url_array, $func_search_match, array('`content`'));
	} else {
		$search_sql = '1=1';
	}  
	
	// how many lines of excerpt we want to have at most
	$max_excerpt_num = $func_default_max_excerpt;
	$divider = ".";
	$result = false;
	
	// we have to get 'content' instead of 'text', because strip_tags() dosen't remove scripting well.
	// scripting will be removed later on automatically
	$content = $func_database->get_one("SELECT `content` FROM `".TABLE_PREFIX."mod_wysiwyg` WHERE `section_id` = ".$func_section_id );

	if($content != "") 
	{
		// Aldus: 2020-09-03 for L* 5 since using HTMLPurifier in WYSIWYG-sections
		$content = str_replace(["&lt;", "&gt;"],["<", ">"], $content);
		
		$mod_vars = array(
			'page_link' => $func_page_link,
			'page_link_target' => "#wb_section_$func_section_id",
			'page_title' => $func_page_title,
			'page_description' => $func_page_description,
			'page_modified_when' => $func_page_modified_when,
			'page_modified_by' => $func_page_modified_by,
			'text' => $content.$divider,
			'max_excerpt_num' => $max_excerpt_num
		);
		if(print_excerpt2($mod_vars, $func_vars)) {
			$result = true;
		}
	}
	return $result;
}

?>
