//:Shows an \\\"Edit page\\\" link in the frontend
//:Usage: [[editthispage]]
/**
 * Version 2 for L* >= 4.5
 * This Droplet will show a link to the backend page editor. This is only shown when the user is logged in and has the correct permissions to edit the page in question.
 */
global $oLEPTON, $page_id, $HEADING, $database, $admin;
$str = " ";		
if (FRONTEND_LOGIN == 'enabled' AND is_numeric($oLEPTON->get_session('USER_ID')))
{
	if (true === isset($page_id))
	{ 
		$this_page = $page_id;
	} else {
		$this_page = $oLEPTON->default_page_id;
		$page_id = $this_page;
	}
	
	$results_array = [];
	$database->execute_query(
	    "SELECT * FROM `".TABLE_PREFIX."pages` WHERE `page_id` = ".$this_page,
	    true,
	    $results_array,
	    false
	);

	// fix aldus 2020-02-17
	if( count($results_array) == 0)
	{
		return "";
	}
	
	$old_admin_groups   = explode(',', $results_array['admin_groups']);
	$old_admin_users    = explode(',', $results_array['admin_users']);
	$this_user          = $oLEPTON->get_session('GROUP_ID');

	$page = [];

	$database->execute_query(
	    "SELECT * FROM ".TABLE_PREFIX."pages WHERE page_id = '".$page_id."'",
	    true,
	    $page,
	    false
	);

	$admin_groups = explode(',', str_replace('_', '', $page['admin_groups']));
	$admin_users = explode(',', str_replace('_', '', $page['admin_users']));
	$in_group = FALSE;

	foreach($admin->get_groups_id() as $cur_gid)
		if (in_array($cur_gid, $admin_groups)) $in_group = TRUE;
	if (($in_group) OR is_numeric(array_search($this_user, $old_admin_groups)) ) {
		$str  = '<a href="' . ADMIN_URL . '/pages/modify.php?page_id='.$this_page;
		$str .= '" target="_blank"><img align="left" border="0" src="';
		$str .= LEPTON_URL . '/modules/lib_lepton/backend_images/modify_16.png" alt="' . $HEADING['MODIFY_PAGE'] . '" />Edit Page</a>';
	}      
}

return $str;
// end droplet
