<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2021 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);
 
// remove not installed standard templates
$lepton3 = $database->get_one("SELECT addon_id FROM ".TABLE_PREFIX."addons WHERE type = 'template' and directory = 'lepton3' ");
if($lepton3 === NULL)
{
	LEPTON_handle::delete_obsolete_directories( '/templates/lepton3' );
}

$semantic = $database->get_one("SELECT addon_id FROM ".TABLE_PREFIX."addons WHERE type = 'template' and directory = 'semantic' ");
if($semantic === NULL)
{
	LEPTON_handle::delete_obsolete_directories( '/templates/semantic' );
}

$blank = $database->get_one("SELECT addon_id FROM ".TABLE_PREFIX."addons WHERE type = 'template' and directory = 'blank' ");
if($blank === NULL)
{
	LEPTON_handle::delete_obsolete_directories( '/templates/blank' );
}

// start with update 

echo ('<h3>Current process: updating to LEPTON 5.3.0</h3>');

echo ('<h5>Current process : rewrite config file</h5>'); 

if(file_exists (LEPTON_PATH.'/config/config.php')) 
{

// rewrite content
$config_content = "" .
"<?php\n".
"\n".
"if(defined('LEPTON_PATH')) { die('By security reasons it is not permitted to load \'config.php\' twice!! ".
"Forbidden call from \''.\$_SERVER['SCRIPT_NAME'].'\'!'); }\n\n".
"// config file created by ".CORE." ".LEPTON_VERSION."\n".
"\n".
"define('LEPTON_PATH', dirname(dirname(__FILE__)));\n".
"define('LEPTON_URL', '".LEPTON_URL."');\n".
"define('ADMIN_PATH', LEPTON_PATH.'/backend');\n".
"define('ADMIN_URL', LEPTON_URL.'/backend');\n".
"\n".
"define('LEPTON_GUID', '".LEPTON_GUID."');\n".
"\n".
"if (!defined('LEPTON_INSTALL')) require_once(LEPTON_PATH.'/framework/initialize.php');\n".
"\n".
"?>";	
	file_put_contents(LEPTON_PATH.'/config/config.php',$config_content);
} 
echo "<h5>Rewrite config file: successfull</h5>"; 


echo ('<h5>Current process: set charset</h5>');
$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='utf-8' WHERE name = 'default_charset' ");
$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='utf-8' WHERE name = 'link_charset' ");
echo "<h5>set charset: successfull!</h5><br />";

echo '<h5>Current process: delete not needed files and directories</h5>';
// [1] directories
$directory_names = array(
	'/modules/lib_phpmailer/phpmailer/docs'
);
LEPTON_handle::delete_obsolete_directories( $directory_names );

// [2] files
$file_names = array(
	'/framework/functions/function.load_module_language.php'
);
LEPTON_handle::delete_obsolete_files( $file_names );
echo "<h5>Delete not needed files and directories: successfull</h5>";

	
// install new modules
echo '<h5>Current process: run modules install.php</h5>';
$module_names = array(
//	"lib_comp"
);
LEPTON_handle::install_modules($module_names);
echo "<h5>run install.php of new modules: successfull</h5>";


// upgrade updated modules
echo '<h5>Current process: run modules upgrade.php</h5>';
$module_names = array(
	"captcha_control",
	"code2",
	"droplets",
	"initial_page",
	"lib_comp",
	"lib_jquery",
	"lib_lepton",
	"lib_phpmailer",
	"lib_r_filemanager",
	"lib_search",
	"lib_twig",
	"menu_link",
	"news",
	"tinymce"
);
LEPTON_handle::upgrade_modules($module_names);
echo "<h5>run upgrade.php of modified modules: successfull</h5>";


// update release and success message
echo ('<h5>Current process: set new release number</h5>');
$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='5.3.0' WHERE name = 'lepton_version' ");
echo "<h5>update to LEPTON 5.3.0 successfull!</h5><br />";