<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          lib_lepton
 * @author          LEPTON Project
 * @copyright       2010-2022 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/class.secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

//delete directories
$directories = array(
	"/modules/lib_lepton/notie",
	"/modules/lib_lepton/hash"
); 
LEPTON_handle::delete_obsolete_directories($directories);


$files = array(
	"/modules/lib_lepton/upload/lang/class.upload.ru_RU.php",
	"/modules/lib_lepton/upload/lang/class.upload.es_ES.php",
	"/modules/lib_lepton/upload/lang/class.upload.da_DK.php",
	"/modules/lib_lepton/upload/lang/class.upload.it_IT.php",
	"/modules/lib_lepton/upload/lang/class.upload.no_NO.php",
	"/modules/lib_lepton/upload/lang/class.upload.pl_PL.php",
	"/modules/lib_lepton/upload/lang/class.upload.pt_BR.php"
); 
LEPTON_handle::delete_obsolete_files($files);