<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 *
 * @function		display_wysiwyg_editor
 * @author          LEPTON Project
 * @copyright       2022-2022 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/class.secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;  
	} else {
		trigger_error(sprintf("[ %s ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php


/**
 *	Function called by parent, default by the wysiwyg-module
 *	
 *	@param	string	The name of the textarea to watch
 *	@param	mixed	The "id" - some other modules handel this param differ
 *	@param	string	Optional the width
 *	@param	string	Optional the height of the editor
 *
 */
function display_wysiwyg_editor( $name, $id, $content, $width=NULL, $height=NULL, $prompt=true)
{ 
	ob_start();
	$result = eval('return '.WYSIWYG_EDITOR.'::show_wysiwyg_editor("'.$name.'", "'.$id.'", "'.$content.'", '.$width.', '.$height.', '.$prompt.');');
	$result = ob_get_clean();
	if($prompt == true)
	{
		echo $result;
	}
	else
	{
		return $result;
	}
}