<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2022 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 */


// set error level
 ini_set('display_errors', 1);
 error_reporting(E_ALL|E_STRICT);
 
// routine: remove not installed standard templates
$lepton3 = $database->get_one("SELECT addon_id FROM ".TABLE_PREFIX."addons WHERE type = 'template' and directory = 'lepton3' ");
if($lepton3 === NULL)
{
	LEPTON_handle::delete_obsolete_directories( '/templates/lepton3' );
}

$semantic = $database->get_one("SELECT addon_id FROM ".TABLE_PREFIX."addons WHERE type = 'template' and directory = 'semantic' ");
if($semantic === NULL)
{
	LEPTON_handle::delete_obsolete_directories( '/templates/semantic' );
}

$blank = $database->get_one("SELECT addon_id FROM ".TABLE_PREFIX."addons WHERE type = 'template' and directory = 'blank' ");
if($blank === NULL)
{
	LEPTON_handle::delete_obsolete_directories( '/templates/blank' );
}

// start with update
echo ('<h3>Current process: updating to LEPTON 5.5.0</h3>');

echo '<h5>Current process: delete not needed files and directories</h5>';
	// [1] directories
	$directory_names = array(
	//	'/modules/lib_phpmailer/phpmailer/docs'
	);
	LEPTON_handle::delete_obsolete_directories( $directory_names );

	// [2] files
	$file_names = array(
		'/framework/classes/lepton_system.php'
	);
LEPTON_handle::delete_obsolete_files( $file_names );
echo "<h5>Delete not needed files and directories: successfull</h5>";

echo '<h5>Current process: add new image types to settings</h5>';
	$temp_whitelist = $database->get_one("SELECT value FROM ".TABLE_PREFIX."settings WHERE name = 'upload_whitelist' ");
	$value_whitelist = $temp_whitelist.',webp,avif,jxl';
	$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value = '".$value_whitelist."' WHERE name = 'upload_whitelist' ");
echo "<h5> add new image types to settings: successfull</h5>";


// uninstall outdated modules
$module_name = 'Wysiwyg Admin';
$module_dir = 'wysiwyg_admin';
echo '<h5>Current process: uninstall addon '.$module_name.'</h5>';
	$database->simple_query("DELETE FROM ".TABLE_PREFIX."addons WHERE directory = '".$module_dir."' ");
	LEPTON_handle::drop_table('mod_wysiwyg_admin');
	$database->simple_query("DELETE from `".TABLE_PREFIX."sections` where `section_id`='-1' AND `page_id`='-120'");
	$database->simple_query("DELETE from `".TABLE_PREFIX."mod_wysiwyg` where `section_id`='-1' AND `page_id`='-120'");

	LEPTON_handle::delete_obsolete_directories( '/modules/'.$module_dir );
	LEPTON_handle::delete_obsolete_directories( '/templates/talgos/backend/'.$module_dir );
echo '<h5>uninstall process of outdated addon '.$module_name.': successfull</h5>';


// install new modules
$module_name = 'Wysiwyg Settings';
echo '<h5>Current process: install addon '.$module_name.'</h5>';
	$module_names = array(
		"wysiwyg_settings"
	);
	LEPTON_handle::install_modules($module_names);
echo '<h5>install process of new addon '.$module_name.': successfull</h5>';	


// upgrade updated modules
echo '<h5>Current process: run modules upgrade.php</h5>';
	$module_names = array(
		"captcha_control",
		"edit_area",
		"lib_jquery",
		"lib_lepton",
		"lib_phpmailer",
		"lib_r_filemanager",
		"lib_search",
		"lib_twig",
		"news",
		"quickform",
		"tinymce"
	);
	LEPTON_handle::upgrade_modules($module_names);
echo "<h5>run upgrade.php of modified modules: successfull</h5>";


// update release and success message
echo ('<h5>Current process: set new release number</h5>');
	$database->simple_query("UPDATE ".TABLE_PREFIX."settings SET value ='5.5.0' WHERE name = 'lepton_version' ");
echo "<h5>update to LEPTON 5.5.0 successfull!</h5><br />";