<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module          lib_phpmailer
 * @author          LEPTON Project
 * @copyright       2010-2022 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         http://www.gnu.org/licenses/gpl.html
 * @license_terms   please see info.php of this module
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/class.secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

$source = '/modules/lib_phpmailer/phpmailer/language/phpmailer.';
$file_names = array(
	$source.'lang-af.php',
	$source.'lang-ar.php',
	$source.'lang-az.php',
	$source.'lang-ba.php',
	$source.'lang-be.php',
	$source.'lang-bg.php',
	$source.'lang-ca.php',
	$source.'lang-ch.php',
	$source.'lang-cs.php',
	$source.'lang-da.php',
	$source.'lang-el.php',
	$source.'lang-eo.php',
	$source.'lang-es.php',
	$source.'lang-et.php',
	$source.'lang-fa.php',
	$source.'lang-fi.php',
	$source.'lang-fo.php',
	$source.'lang-gl.php',
	$source.'lang-he.php',
	$source.'lang-hi.php',
	$source.'lang-hr.php',
	$source.'lang-hu.php',
	$source.'lang-hy.php',
	$source.'lang-id.php',
	$source.'lang-ja.php',
	$source.'lang-ka.php',
	$source.'lang-ko.php',
	$source.'lang-lt.php',
	$source.'lang-lv.php',
	$source.'lang-mg.php',
	$source.'lang-ms.php',
	$source.'lang-nb.php',
	$source.'lang-pl.php',
	$source.'lang-pt.php',
	$source.'lang-pt_br.php',
	$source.'lang-ro.php',
	$source.'lang-ru.php',
	$source.'lang-sk.php',
	$source.'lang-sl.php',
	$source.'lang-sr.php',
	$source.'lang-sr_latn.php',
	$source.'lang-sv.php',
	$source.'lang-tl.php',
	$source.'lang-tr.php',
	$source.'lang-vi.php',
	$source.'lang-zh.php',
	$source.'lang-zh_cn.php'
);
LEPTON_handle::delete_obsolete_files( $file_names );