<?php

/**
 *  @module         TinyMCE
 *  @version        see info.php of this module
 *  @authors        erpe, Dietrich Roland Pehlke (Aldus)
 *  @copyright      2012-2022 erpe, Dietrich Roland Pehlke (Aldus)
 *  @license        MIT  License
 *  @license terms  see info.php of this module
 *  @platform       see info.php of this module
 *
 *  Please note: TINYMCE is distributed under the <a href="https://github.com/tinymce/tinymce/blob/develop/LICENSE.TXT">MIT License</a> 
 *
 *
 */

// include class.secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/class.secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include class.secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include class.secure.php

$database = LEPTON_database::getInstance();
//remove obsolete files upgrade from 5.x to 6.x
$release = $database->get_one("SELECT version FROM ".TABLE_PREFIX."addons WHERE directory = 'tinymce'");
if ($release < '6.0') 
{
	$files = array (
		'/modules/tinymce/tinymce/jquery.tinymce.min.js',
		'/modules/tinymce/tinymce/langs/cs.js',
		'/modules/tinymce/tinymce/langs/da.js',
		'/modules/tinymce/tinymce/langs/en.js',
		'/modules/tinymce/tinymce/langs/it.js',
		'/modules/tinymce/tinymce/langs/no.js',
		'/modules/tinymce/tinymce/langs/pl.js',
		'/modules/tinymce/tinymce/langs/ru.js',
		'/modules/tinymce/tinymce/themes/silver/theme.js',
		'/modules/tinymce/class.editorinfo.php'
	);
	LEPTON_handle::delete_obsolete_files($files);

	LEPTON_handle::delete_obsolete_directories('/modules/tinymce/tinymce/themes/mobile');


	LEPTON_handle::delete_obsolete_directories('/modules/tinymce/tinymce/plugins');	
	rename( LEPTON_PATH.'/modules/tinymce/tinymce/plugins_6',LEPTON_PATH .'/modules/tinymce/tinymce/plugins');
}
